/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.option;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.thinkingstudio.obsidianui.Position;
import org.thinkingstudio.obsidianui.option.SpruceOption;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceNamedTextFieldWidget;
import org.thinkingstudio.obsidianui.widget.text.SpruceTextFieldWidget;

public class SpruceFloatInputOption
extends SpruceOption {
    private final Supplier<Float> getter;
    private final Consumer<Float> setter;

    public SpruceFloatInputOption(String key, Supplier<Float> getter, Consumer<Float> setter, @Nullable class_2561 tooltip) {
        super(key);
        this.getter = getter;
        this.setter = setter;
        this.setTooltip(tooltip);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceTextFieldWidget textField = new SpruceTextFieldWidget(position, width, 20, this.getPrefix());
        textField.setText(String.valueOf(this.get()));
        textField.setTextPredicate(SpruceTextFieldWidget.FLOAT_INPUT_PREDICATE);
        textField.setRenderTextProvider((displayedText, offset) -> {
            try {
                Float.parseFloat(textField.getText());
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360);
            }
            catch (NumberFormatException e) {
                return class_5481.method_30747((String)displayedText, (class_2583)class_2583.field_24360.method_10977(class_124.field_1061));
            }
        });
        textField.setChangedListener(input -> {
            float value;
            try {
                value = Float.parseFloat(input);
            }
            catch (NumberFormatException e) {
                value = 0.0f;
            }
            this.set(value);
        });
        this.getOptionTooltip().ifPresent(textField::setTooltip);
        return new SpruceNamedTextFieldWidget(textField);
    }

    public void set(float value) {
        this.setter.accept(Float.valueOf(value));
    }

    public float get() {
        return this.getter.get().floatValue();
    }
}

